Info<< "Reading field Concentration\n" << endl;

volScalarField Cp
(
    IOobject
    (
        "Cp",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);

volScalarField Cn
(
    IOobject
    (
        "Cn",
        runTime.timeName(),
        mesh,
        IOobject::MUST_READ,
        IOobject::AUTO_WRITE
    ),
    mesh
);


Info<< "Reading transportProperties\n" << endl;

IOdictionary transportProperties
(
    IOobject
    (
        "transportProperties",
        runTime.constant(),
        mesh,
        IOobject::MUST_READ_IF_MODIFIED,
        IOobject::NO_WRITE
    )
);


Info<< "Reading diffusivity DT\n" << endl;

dimensionedScalar DP ( transportProperties.lookup("DP"));
dimensionedScalar DN ( transportProperties.lookup("DN"));
dimensionedScalar Cpmax ( transportProperties.lookup("Cpmax"));
dimensionedScalar Cnmax ( transportProperties.lookup("Cnmax"));


dimensionedScalar I ( transportProperties.lookup("I"));
dimensionedScalar Ce ( transportProperties.lookup("Ce"));
dimensionedScalar F ( transportProperties.lookup("F"));
dimensionedScalar T ( transportProperties.lookup("T"));
dimensionedScalar R ( transportProperties.lookup("R"));
dimensionedScalar U0 ( transportProperties.lookup("U0"));

dimensionedScalar Rp ( transportProperties.lookup("Rp"));
dimensionedScalar Rn ( transportProperties.lookup("Rn"));
dimensionedScalar kp ( transportProperties.lookup("kp"));
dimensionedScalar kn ( transportProperties.lookup("kn"));
dimensionedScalar Ln ( transportProperties.lookup("Ln"));
dimensionedScalar Lp ( transportProperties.lookup("Lp"));

dimensionedScalar solidfn ( transportProperties.lookup("fn"));
dimensionedScalar solidfp ( transportProperties.lookup("fp"));


#include "createFvOptions.H"
